//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ProcessCommand(int Client, char *ReceivedData, int ReceivedSize)
{
    int FlagLength = 0;
    int FlaggedLength = 0;
    char FlaggedData[MaxReceiveSize + 1];
    char StatusTemp[255];

    if(strcmp(ReceivedData, "::RequestFirstStatement") == 0)
    {
        sprintf(StatusTemp, "(%d) Received Command: RequestFirstStatement.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        char Statement[255];
        sprintf(Statement, "SELECT Statement, ImportTable FROM WP_Statements WHERE Active = 1 ORDER BY Sequence");

        if(!CI[Client].WPCustDB.DBExecute(Statement, &CI[Client].StatementsHandle))
        {
            sprintf(StatusTemp, "(%d) Command: DBexecute filed in RequestFirstStatement.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);
            glErrorCount++;
            return COMMAND_RESULT_ERROR;
        }
        else{
            sprintf(StatusTemp, "(%d) Command: RequestFirstStatement DBexecute success.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);
        }

        int SendResult = SendNextStatement(Client);
        if(SendResult == SENDNEXTSTATEMENT_SUCCESS){
            return COMMAND_RESULT_OK;
        }
        else if(SendResult == SENDNEXTSTATEMENT_FAILURE){
            sprintf(StatusTemp, "(%d) Command: Failed to send first statement.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);
            SimpleServerSend(Client, "::Error:Server failed to send first statement.");
            glErrorCount++;
            return COMMAND_RESULT_ERROR;
        }
        else if(SendResult == SENDNEXTSTATEMENT_DONE){
            sprintf(StatusTemp, "(%d) Command: End of statements.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);
            SimpleServerSend(Client, "::EndOfStatements");
            return COMMAND_RESULT_OK;
        }

        sprintf(StatusTemp, "(%d) Error in ProcessCommand :: Logic failed in RequestFirstStatement.", MyServer.ClientID[Client]);
        glErrorCount++;
        WriteLog(StatusTemp);

        return COMMAND_RESULT_ERROR; // Should never get here
    }
    else if(strcmp(ReceivedData, "::RequestNextStatement") == 0)
    {
        sprintf(StatusTemp, "(%d) Received Command: RequestNextStatement.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        int SendResult = SendNextStatement(Client);
        if(SendResult == SENDNEXTSTATEMENT_SUCCESS){
            return COMMAND_RESULT_OK;
        }
        else if(SendResult == SENDNEXTSTATEMENT_FAILURE){
            sprintf(StatusTemp, "(%d) Command: Failed to send next statement.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);
            SimpleServerSend(Client, "::Error:Server failed to send next statement.");
            glErrorCount++;
            return COMMAND_RESULT_ERROR;
        }
        else if(SendResult == SENDNEXTSTATEMENT_DONE){
            sprintf(StatusTemp, "(%d) Command: End of statements.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);
            SimpleServerSend(Client, "::EndOfStatements");
            return COMMAND_RESULT_OK;
        }

        return COMMAND_RESULT_ERROR; // Should never get here
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::FileName:")))
    {
        sprintf(StatusTemp, "(%d) Received Command: FileName.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        sprintf(CI[Client].FileName, "%s\\%s\\%s.wpd", gsClientFilesTemp, CI[Client].CompanyName, FlaggedData);
        CreateFolderStructure(CI[Client].FileName);

        sprintf(StatusTemp, "(%d) Command: FileName: '%s'.", MyServer.ClientID[Client], CI[Client].FileName);
        WriteLog(StatusTemp);

        if(ReceiveFileData(Client, CI[Client].FileName))
        {
            SimpleServerSend(Client, "::FileCRC");
            return COMMAND_RESULT_OK;
        }

        return COMMAND_RESULT_ERROR;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::FileCRC:")))
    {
        sprintf(StatusTemp, "(%d) Received Command: FileCRC.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        DWORD ClientFileCRC = atol(FlaggedData);

        if(ClientFileCRC == CI[Client].DataCRC)
        {
            sprintf(StatusTemp, "(%d) Command: Data transfer CRC success.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);

            if(ImportSQLResults(Client, CI[Client].FileName))
            {
                SimpleServerSend(Client, "::LastImportSuccess");
                // FIXME: Should we return COMMAND_RESULT_ERROR, COMMAND_RESULT_DISCONNECT or COMMAND_RESULT_OK
                return COMMAND_RESULT_OK;
            }
            else{
                SimpleServerSend(Client, "::LastImportFailed");
                // FIXME: Should we return COMMAND_RESULT_ERROR, COMMAND_RESULT_DISCONNECT or COMMAND_RESULT_OK
                return COMMAND_RESULT_OK;
            }
        }
        else{
            sprintf(StatusTemp, "(%d) Command: Data CRC failed: Client(%x) / Server(%x).", MyServer.ClientID[Client], ClientFileCRC, CI[Client].DataCRC);
            WriteLog(StatusTemp);
            SimpleServerSend(Client, "::DataCRCFailed");
            // FIXME: Should we return COMMAND_RESULT_ERROR, COMMAND_RESULT_DISCONNECT or COMMAND_RESULT_OK
            glErrorCount++;
            return COMMAND_RESULT_OK;
        }

        WriteLog("Error in ProcessCommand :: Logic failed in FileCRC.");
        glErrorCount++;
        return COMMAND_RESULT_ERROR; // Should never get here
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::FileSize:")))
    {
        sprintf(StatusTemp, "(%d) Received Command: FileSize.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        CI[Client].FileSize = atol(FlaggedData);

        sprintf(StatusTemp, "(%d) Command: FileSize: %d.", MyServer.ClientID[Client], CI[Client].FileSize);
        WriteLog(StatusTemp);

        return COMMAND_RESULT_OK;
    }

    sprintf(StatusTemp, "(%d) Received Command: Unknown command.", MyServer.ClientID[Client]);
    WriteLog(StatusTemp);

    glErrorCount++;
    return COMMAND_RESULT_UNKNOWN;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

